/*
     Exemple d'utilisation des fonctions du module comparateurs.
  *
     valide pour la famille 16f87Xa,
  *
     En cet exemple on utilise le comparateur 1 con Vref interne al 50\% de Vdd,
  *
     connecter la tension à comparer à RA0,
  *
     connecter une led ou une autre sortie à RB7.
  *
     RB7 se mettra à l'état haut (Vdd) quand la tension en RA0 sera inférieure à 50\% de Vdd
  *
*/
\#include <pic/p16f877a.h>
\#include <comp.h>
int main(void)
{
     TRISAbits.TRISA0 = 1;           // A0 comme entée
     TRISAbits.TRISA3 = 1;           // A3 comme entrée
     TRISBbits.TRISB7 = 0;           // B7 como sortie
     comp\_init( TWO\_COMP\_MULTI4\_VREF ); // Initialise les comparateurs en modo multiplexé con V
     comp\_set\_vref( VREF\_50 );         // Establece Vref en 50\% Vdd
     while (1)
     {

         if ( comp1\_read() == 1 )    // lee comparador 1 = comprueba bit C1OUT de regist
             PORTBbits.RB7 = 1;      // Enciende led
         else
             PORTBbits.RB7 = 0;      // Apaga led
     }
}

